 /***************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Processor
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 ****************************************************/

 #ifndef __BSprocessor6_H
 #define __BSprocessor6_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class BSprocessor6 : public Atomic
 {
   public:
	       BSprocessor6 ( const std::string &name = "BSprocessor6" );  //Default constructor
	       virtual std::string className() const {  return "BSprocessor6" ;}
	       ~BSprocessor6();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In;
	        Port &OB0,&OB1,&OB2,&OB3,&OB4,&OB5,&Req;
	        Time ProcessTime;
	        int Temp,i,j,CurrentCell;
	        int UEinBS [7][3];
	        int NextHop [10];
	        int Neighborhood [7];
	        int Digit [6];
	        int MyUEMode [3];
	        int Turn;
	        int BSMes1,BSMes2,BSMes1Port,BSMes2Port;
	        int UECoordinationSet [3][3];
	        int OutPort;
         	enum State{
			            Idle,
			            SetCSMode,
			            NormalMode,
			            InfoMode,
			            AskNewTask,
		              };
		    State state;
 };

#endif   //__BSprocessor6_H
